<?php
function civilconstruction_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'civilconstruction_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => '344170',
		'width'                  => 2000, 
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'civilconstruction_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'civilconstruction_custom_header_setup' );

if ( ! function_exists( 'civilconstruction_header_style' ) ) :

function civilconstruction_header_style() {
	$header_text_color = get_header_textcolor();

	$civilconstruction_logo_top_padding = esc_attr(get_theme_mod('civilconstruction_logo_top_padding','2'));
	$civilconstruction_logo_right_padding = esc_attr(get_theme_mod('civilconstruction_logo_right_padding','2'));
	$civilconstruction_logo_bottom_padding = esc_attr(get_theme_mod('civilconstruction_logo_bottom_padding','2'));
	$civilconstruction_logo_left_padding = esc_attr(get_theme_mod('civilconstruction_logo_left_padding','2'));


	$Service_disable_section = esc_attr(get_theme_mod('Service_disable_section','YES'));

	?>
	<style type="text/css">


		.logo img {
			margin-top: <?php echo apply_filters('civilconstruction_topheader', $civilconstruction_logo_top_padding); ?>px;
			margin-left: <?php echo apply_filters('civilconstruction_topheader', $civilconstruction_logo_right_padding); ?>px;
			margin-bottom: <?php echo apply_filters('civilconstruction_topheader', $civilconstruction_logo_bottom_padding); ?>px;
			margin-right: <?php echo apply_filters('civilconstruction_topheader', $civilconstruction_logo_left_padding); ?>px;
		}

		.main-header h4.site-title {
			color: <?php echo esc_attr(get_theme_mod('topheader_sitetitlecol')); ?> !important;
		}

		.main-header .logo a {
			text-decoration-color: <?php echo esc_attr(get_theme_mod('topheader_sitetitlecol')); ?> !important;
		}

		.main-header p.site-description {
			color: <?php echo esc_attr(get_theme_mod('topheader_taglinecol')); ?> !important;
		}




		.main-header .topheader {
			background: <?php echo esc_attr(get_theme_mod('topheader_bgcolor')); ?>;
		}

		.main-header .topheader .space p {
			color: <?php echo esc_attr(get_theme_mod('topheader_titlecolor')); ?> !important;
		}

		.main-header .topheader .col-space-content .civilconstruction-phone-label {
			color: <?php echo esc_attr(get_theme_mod('topheader_phncolor')); ?> !important;
		}

		.main-header .topheader .col-space-content .civilconstruction-email-label {
			color: <?php echo esc_attr(get_theme_mod('topheader_mailcolor')); ?> !important;
		}

		.border-right {
			border-color: <?php echo esc_attr(get_theme_mod('topheader_bordercolor')); ?>;
		}




		.hero-style .slide-title h2 {
			color: <?php echo esc_attr(get_theme_mod('slider_titlecolor')); ?>;
		}
		
		.hero-style .slide-text p {
			color: <?php echo esc_attr(get_theme_mod('slider_descriptioncolor')); ?>;
		}

		.hero-style a.ReadMore {
			color: <?php echo esc_attr(get_theme_mod('slider_btntextcolor')); ?> !important;
		}

		.hero-style a.ReadMore {
			background: <?php echo esc_attr(get_theme_mod('slider_btnbgcolor')); ?>;
		}

		.hero-style a.ReadMore:hover {
			color: <?php echo esc_attr(get_theme_mod('slider_btntexthovercolor')); ?> !important;
		}

		.hero-style a.ReadMore:hover {
			background: <?php echo esc_attr(get_theme_mod('slider_btnbghovercolor')); ?>;
		}

		.hero-slider .swiper-button-prev:before {
			color: <?php echo esc_attr(get_theme_mod('slider_arrowiconcolor')); ?>;
				border-color: <?php echo esc_attr(get_theme_mod('slider_arrowiconcolor')); ?>;
		}
		.hero-slider .swiper-button-next:before{
			color: <?php echo esc_attr(get_theme_mod('slider_arrowiconcolor')); ?>;
			border-color: <?php echo esc_attr(get_theme_mod('slider_arrowiconcolor')); ?>;
		}



		
		#service-section .header-section .title {
			color: <?php echo esc_attr(get_theme_mod('Service_headingcolor')); ?>;
		}

		#service-section .single-service .part-2 h3.title {
			color: <?php echo esc_attr(get_theme_mod('Service_titlecolor')); ?>;
		}

		#service-section .single-service .part-2 a {
			color: <?php echo esc_attr(get_theme_mod('Service_btntextcolor')); ?>;
		}

		#service-section .single-service .part-2 a {
			background: <?php echo esc_attr(get_theme_mod('Service_btnbgcolor')); ?>;
		}

		#service-section .single-service .part-2 a:hover {
			background: <?php echo esc_attr(get_theme_mod('Service_btnbghrvcolor')); ?>;
		}

		#service-section .single-service .part-2 {
			border-bottom-color: <?php echo esc_attr(get_theme_mod('Service_boxbordercolor')); ?>;
		}

		#service-section {
			padding-top: <?php echo esc_attr(get_theme_mod('civilconstruction_Service_section_t_padding')); ?>em;
		}

		#service-section {
			padding-bottom: <?php echo esc_attr(get_theme_mod('civilconstruction_Service_section_b_padding')); ?>em;
		}


		section#slider-section {
			padding-top: <?php echo esc_attr(get_theme_mod('civilconstruction_slider_section_t_padding')); ?>em;
		}

		section#slider-section {
			padding-bottom: <?php echo esc_attr(get_theme_mod('civilconstruction_slider_section_b_padding')); ?>em;
		}


	<?php
		if ( ! display_header_text() ) :
	?>
		.site-title,
		.site-description {
			position: absolute;
			clip: rect(1px, 1px, 1px, 1px);
		}
	<?php
		else :
	?>
		h4.site-title,
		p.site-description {
			color: #<?php echo esc_attr( $header_text_color ); ?>;
		}
	<?php endif; ?>

	<?php
        if ($Service_disable_section == 1):
	?>
		#service-section {
			display: none;
		}
	<?php
		else :
	?>
		#service-section {
			display: block;
		}
	<?php endif; ?>

	</style>
	<?php
}
endif;
