<?php
function civilconstruction_blog_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
			'civilconstruction_frontpage_sections', array(
				'priority' => 32,
				'title' => esc_html__( 'Frontpage Sections', 'civil-construction' ),
			)
		);
	 


	/*=========================================
	Slider Section
	=========================================*/
	$wp_customize->add_section(
		'slider_setting', array(
			'title' => esc_html__( 'Slider Section', 'civil-construction' ),
			'priority' => 13,
			'panel' => 'civilconstruction_frontpage_sections',
		)
	);
	  
  
  
	  $wp_customize->add_setting('civilconstruction_top_slider_tabs', array(
		 'sanitize_callback' => 'wp_kses_post',
	  ));
  
	  $wp_customize->add_control(new civilconstruction_Tab_Control($wp_customize, 'civilconstruction_top_slider_tabs', array(
		 'section' => 'slider_setting',
		 'priority' => 1,
		 'buttons' => array(
			array(
			   'name' => esc_html__('General', 'civil-construction'),
			   'icon' => 'dashicons dashicons-welcome-write-blog',
			  'fields' => array(
				  'slider1',
				  'slider2',
				  'slider3',
				  'slider4',
				  'slider5'
  
			  ),
			  'active' => true,
		   ),
			array(
			  'name' => esc_html__('Style', 'civil-construction'),
			  'icon' => 'dashicons dashicons-art',
			  'fields' => array(
				  'slider_titlecolor',
				  'slider_descriptioncolor',
				  'slider_btntextcolor',
				  'slider_btnbgcolor',
				  'slider_btntexthovercolor',
				  'slider_btnbghovercolor',
				  'slider_arrowiconcolor'

			  ),
		   ),
		   array(
			 'name' => esc_html__('Layout', 'civil-construction'),
			 'icon' => 'dashicons dashicons-layout',
			 'fields' => array(
				 'slider_section_width',
				 'civilconstruction_slider_padding',
				 'civilconstruction_slider_section_t_padding',
				 'civilconstruction_slider_section_b_padding'
			 ),
		  )
		  
		  ),
	  )));
  
	


	// Slider 1
	$wp_customize->add_setting( 
    	'slider1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'slider1',
		array(
		    'label'   		=> __('Slider 1','civil-construction'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		



	// Slider 2
	$wp_customize->add_setting(
    	'slider2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'slider2',
		array(
		    'label'   		=> __('Slider 2','civil-construction'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Slider 3
	$wp_customize->add_setting(
    	'slider3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider3',
		array(
		    'label'   		=> __('Slider 3','civil-construction'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Slider 4
	$wp_customize->add_setting(
    	'slider4',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'slider4',
		array(
		    'label'   		=> __('Slider 4','civil-construction'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);



	// Slider 5
	$wp_customize->add_setting(
    	'slider5',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'slider5',
		array(
		    'label'   		=> __('Slider 5','civil-construction'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);


	//style

	// slider title color
	$slidertitlecolor = esc_html__('#001658', 'civil-construction' );
	$wp_customize->add_setting(
    	'slider_titlecolor',
    	array(
			'default' => $slidertitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'slider_titlecolor',
		array(
		    'label'   		=> __('Title Color','civil-construction'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider description color
	$sliderdescriptioncolor = esc_html__('#514a41', 'civil-construction' );
	$wp_customize->add_setting(
    	'slider_descriptioncolor',
    	array(
			'default' => $sliderdescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'slider_descriptioncolor',
		array(
		    'label'   		=> __('Description Color','civil-construction'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider btntext color
	$sliderbtntextcolor = esc_html__('#c5d1d6', 'civil-construction' );
	$wp_customize->add_setting(
    	'slider_btntextcolor',
    	array(
			'default' => $sliderbtntextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'slider_btntextcolor',
		array(
		    'label'   		=> __('Button Text Color','civil-construction'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider btnbg color
	$sliderbtnbgcolor = esc_html__('#001658', 'civil-construction' );
	$wp_customize->add_setting(
    	'slider_btnbgcolor',
    	array(
			'default' => $sliderbtnbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'slider_btnbgcolor',
		array(
		    'label'   		=> __('Button BG Color','civil-construction'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider btntexthover color
	$sliderbtntexthovercolor = esc_html__('#c5d1d6', 'civil-construction' );
	$wp_customize->add_setting(
    	'slider_btntexthovercolor',
    	array(
			'default' => $sliderbtntexthovercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'slider_btntexthovercolor',
		array(
		    'label'   		=> __('Button Text Hover Color','civil-construction'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider btnbghover color
	$sliderbtnbghovercolor = esc_html__('#ff5e15', 'civil-construction' );
	$wp_customize->add_setting(
    	'slider_btnbghovercolor',
    	array(
			'default' => $sliderbtnbghovercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'slider_btnbghovercolor',
		array(
		    'label'   		=> __('Button BG Hover Color','civil-construction'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	// slider Arrow Indicator color
	$sliderarrowiconcolor = esc_html__('#001454', 'civil-construction' );
	$wp_customize->add_setting(
    	'slider_arrowiconcolor',
    	array(
			'default' => $sliderarrowiconcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'slider_arrowiconcolor',
		array(
		    'label'   		=> __('Indicator Arrow & Border Color','civil-construction'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	




	// layout setting

	$wp_customize->add_setting('slider_section_width',array(
		'default' => 'Full Width',
		'sanitize_callback' => 'civilconstruction_sanitize_choices',
	));
	$wp_customize->add_control('slider_section_width',array(
		'type' => 'select',
		'label' => __('Section Width','civil-construction'),
		'choices' => array (
			'Box Width' => __('Box Width','civil-construction'),
			'Full Width' => __('Full Width','civil-construction')
		),
		'section' => 'slider_setting',
	));


	// slider section padding 
	$wp_customize->add_setting('civilconstruction_slider_padding',array(
		'sanitize_callback'   => 'esc_html'
	));
	$wp_customize->add_control('civilconstruction_slider_padding',array(
		'label' => __('Section Padding','civil-construction'),
		'section' => 'slider_setting'
	));

	$wp_customize->add_setting('civilconstruction_slider_section_t_padding',array(
		'default' => '0',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('civilconstruction_slider_section_t_padding',array(
		'type' => 'number',
		'label' => __('Top','civil-construction'),
		'section' => 'slider_setting',
	));

	$wp_customize->add_setting('civilconstruction_slider_section_b_padding',array(
		'default' => '0',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('civilconstruction_slider_section_b_padding',array(
		'type' => 'number',
		'label' => __('Bottom','civil-construction'),
		'section' => 'slider_setting',
	));




	/*=========================================
	Service Section
	=========================================*/
	$wp_customize->add_section(
		'Service_setting', array(
			'title' => esc_html__( 'Service Section', 'civil-construction' ),
			'priority' => 14,
			'panel' => 'civilconstruction_frontpage_sections',
		)
	);



	$wp_customize->add_setting('civilconstruction_top_Service_tabs', array(
		'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new civilconstruction_Tab_Control($wp_customize, 'civilconstruction_top_Service_tabs', array(
		'section' => 'Service_setting',
		'priority' => 1,
		'buttons' => array(
		array(
			'name' => esc_html__('General', 'civil-construction'),
			'icon' => 'dashicons dashicons-welcome-write-blog',
			'fields' => array(
				'Service_disable_section',
				'Service_heading',
				'Service1',
				'Service2',
				'Service3',
				'Service4',
				'Service5',
				'Service6'

			),
			'active' => true,
		),
		array(
			'name' => esc_html__('Style', 'civil-construction'),
			'icon' => 'dashicons dashicons-art',
			'fields' => array(
				'Service_headingcolor',
				'Service_titlecolor',
				'Service_btntextcolor',
				'Service_btnbgcolor',
				'Service_btnbghrvcolor',
				'Service_boxbordercolor'
			),
		),
		array(
		  'name' => esc_html__('Layout', 'civil-construction'),
		  'icon' => 'dashicons dashicons-layout',
		  'fields' => array(
			  'Service_section_width',
			  'civilconstruction_Service_padding',
			  'civilconstruction_Service_section_t_padding',
			  'civilconstruction_Service_section_b_padding'
		  ),
	   )
		
		),
	)));


	// General

	// hide show Service section
	$wp_customize->add_setting(
        'Service_disable_section',
        array(
            'sanitize_callback' => 'wp_kses_post',
        )
    ); 
    $wp_customize->add_control(
        new civilconstruction_Toggle_Switch_Custom_Control(
            $wp_customize,
            'Service_disable_section',
            array(
                'settings'      => 'Service_disable_section',
                'section'       => 'Service_setting',
                'label'         => __( 'Disable Section', 'civil-construction' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'civil-construction' ),
                    'off' => __( 'No', 'civil-construction' )
                ),
            )
        )
    );

	// Service_heading txt
	$Service_headingtxt = esc_html__('Our Services', 'civil-construction' );
	$wp_customize->add_setting(
    	'Service_heading',
    	array(
			'default' => $Service_headingtxt,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'Service_heading',
		array(
		    'label'   		=> __('Heading','civil-construction'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// Service 1
	$wp_customize->add_setting( 
    	'Service1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'Service1',
		array(
		    'label'   		=> __('Service 1','civil-construction'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		



	// Service 2
	$wp_customize->add_setting(
    	'Service2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'Service2',
		array(
		    'label'   		=> __('Service 2','civil-construction'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Service 3
	$wp_customize->add_setting(
    	'Service3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'Service3',
		array(
		    'label'   		=> __('Service 3','civil-construction'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Service 4
	$wp_customize->add_setting(
    	'Service4',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'Service4',
		array(
		    'label'   		=> __('Service 4','civil-construction'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);



	// Service 5
	$wp_customize->add_setting(
    	'Service5',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'Service5',
		array(
		    'label'   		=> __('Service 5','civil-construction'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);


	// Service 6
	$wp_customize->add_setting(
    	'Service6',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'Service6',
		array(
		    'label'   		=> __('Service 6','civil-construction'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);
	

	//style

	// Service heading color
	$Serviceheadingcolor = esc_html__('#000', 'civil-construction' );
	$wp_customize->add_setting(
    	'Service_headingcolor',
    	array(
			'default' => $Serviceheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'Service_headingcolor',
		array(
		    'label'   		=> __('Heading Color','civil-construction'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// Service title color
	$Servicetitlecolor = esc_html__('#152662', 'civil-construction' );
	$wp_customize->add_setting(
    	'Service_titlecolor',
    	array(
			'default' => $Servicetitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'Service_titlecolor',
		array(
		    'label'   		=> __('Title Color','civil-construction'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// Service btntext color
	$Servicebtntextcolor = esc_html__('#fff', 'civil-construction' );
	$wp_customize->add_setting(
    	'Service_btntextcolor',
    	array(
			'default' => $Servicebtntextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'Service_btntextcolor',
		array(
		    'label'   		=> __('Button Text Color','civil-construction'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// Service btnbg color
	$Servicebtnbgcolor = esc_html__('#ff5e15', 'civil-construction' );
	$wp_customize->add_setting(
    	'Service_btnbgcolor',
    	array(
			'default' => $Servicebtnbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'Service_btnbgcolor',
		array(
		    'label'   		=> __('Button BG Color','civil-construction'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// Service btnbghrv color
	$Servicebtnbghrvcolor = esc_html__('#00165a', 'civil-construction' );
	$wp_customize->add_setting(
    	'Service_btnbghrvcolor',
    	array(
			'default' => $Servicebtnbghrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'Service_btnbghrvcolor',
		array(
		    'label'   		=> __('Button BG Hover Color','civil-construction'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	// Service boxborder color
	$Serviceboxbordercolor = esc_html__('#fe5c15', 'civil-construction' );
	$wp_customize->add_setting(
    	'Service_boxbordercolor',
    	array(
			'default' => $Serviceboxbordercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'Service_boxbordercolor',
		array(
		    'label'   		=> __('Bottom Border Color','civil-construction'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	// layout setting

	$wp_customize->add_setting('Service_section_width',array(
		'default' => 'Box Width',
		'sanitize_callback' => 'civilconstruction_sanitize_choices',
	));
	$wp_customize->add_control('Service_section_width',array(
		'type' => 'select',
		'label' => __('Section Width','civil-construction'),
		'choices' => array (
			'Box Width' => __('Box Width','civil-construction'),
			'Full Width' => __('Full Width','civil-construction')
		),
		'section' => 'Service_setting',
	));

	// Service section padding 
	$wp_customize->add_setting('civilconstruction_Service_padding',array(
		'sanitize_callback'   => 'esc_html'
	));
	$wp_customize->add_control('civilconstruction_Service_padding',array(
		'label' => __('Section Padding','civil-construction'),
		'section' => 'Service_setting'
	));

	$wp_customize->add_setting('civilconstruction_Service_section_t_padding',array(
		'default' => '5',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('civilconstruction_Service_section_t_padding',array(
		'type' => 'number',
		'label' => __('Top','civil-construction'),
		'section' => 'Service_setting',
	));

	$wp_customize->add_setting('civilconstruction_Service_section_b_padding',array(
		'default' => '5',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('civilconstruction_Service_section_b_padding',array(
		'type' => 'number',
		'label' => __('Bottom','civil-construction'),
		'section' => 'Service_setting',
	));


}

add_action( 'customize_register', 'civilconstruction_blog_setting' );

// service selective refresh
function civilconstruction_blog_section_partials( $wp_customize ){	
	// blog_title
	$wp_customize->selective_refresh->add_partial( 'blog_title', array(
		'selector'            => '.home-blog .title h6',
		'settings'            => 'blog_title',
		'render_callback'  => 'civilconstruction_blog_title_render_callback',
	
	) );
	
	// blog_subtitle
	$wp_customize->selective_refresh->add_partial( 'blog_subtitle', array(
		'selector'            => '.home-blog .title h2',
		'settings'            => 'blog_subtitle',
		'render_callback'  => 'civilconstruction_blog_subtitle_render_callback',
	
	) );
	
	// blog_description
	$wp_customize->selective_refresh->add_partial( 'blog_description', array(
		'selector'            => '.home-blog .title p',
		'settings'            => 'blog_description',
		'render_callback'  => 'civilconstruction_blog_description_render_callback',
	
	) );	
	}

add_action( 'customize_register', 'civilconstruction_blog_section_partials' );

// blog_title
function civilconstruction_blog_title_render_callback() {
	return get_theme_mod( 'blog_title' );
}

// blog_subtitle
function civilconstruction_blog_subtitle_render_callback() {
	return get_theme_mod( 'blog_subtitle' );
}

// service description
function civilconstruction_blog_description_render_callback() {
	return get_theme_mod( 'blog_description' );
}