<?php
function civilconstruction_header_settings( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	/*=========================================
	Header Settings Panel
	=========================================*/
	$wp_customize->add_panel( 
		'header_section', 
		array(
			'priority'      => 2,
			'capability'    => 'edit_theme_options',
			'title'			=> __('Header', 'civil-construction'),
		) 
	);

	
	/*=========================================
	civil Construction Site Identity
	=========================================*/
	$wp_customize->add_section(
        'title_tagline',
        array(
        	'priority'      => 1,
            'title' 		=> __('Site Identity','civil-construction'),
			'panel'  		=> 'header_section',
		)
    );


	// logo section padding 
	$wp_customize->add_setting('civilconstruction_logo_padding',array(
		'sanitize_callback'   => 'esc_html'
	));
	$wp_customize->add_control('civilconstruction_logo_padding',array(
		'label' => __('Logo Spacing','civil-construction'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('civilconstruction_logo_top_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('civilconstruction_logo_top_padding',array(
		'type' => 'number',
		'label' => __('Top','civil-construction'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('civilconstruction_logo_left_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('civilconstruction_logo_left_padding',array(
		'type' => 'number',
		'label' => __('Left','civil-construction'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('civilconstruction_logo_bottom_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('civilconstruction_logo_bottom_padding',array(
		'type' => 'number',
		'label' => __('Bottom','civil-construction'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('civilconstruction_logo_right_padding',array(
		'default' => '2',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('civilconstruction_logo_right_padding',array(
		'type' => 'number',
		'label' => __('Right','civil-construction'),
		'section' => 'title_tagline',
	));


	// top header Site Title Color
	$topheadersitetitlecol = esc_html__('#344170', 'civil-construction' );
	$wp_customize->add_setting(
		'topheader_sitetitlecol',
		array(
			'default' => $topheadersitetitlecol,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'topheader_sitetitlecol',
		array(
			'label'   		=> __('Site Title Color','civil-construction'),
			'section'		=> 'title_tagline',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// top header Tagline Color
	$topheadertaglinecol = esc_html__('#344170', 'civil-construction' );
	$wp_customize->add_setting(
		'topheader_taglinecol',
		array(
			'default' => $topheadertaglinecol,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'topheader_taglinecol',
		array(
			'label'   		=> __('Tagline Color','civil-construction'),
			'section'		=> 'title_tagline',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);
	
  

	/*=========================================
	civil Construction Top header
	=========================================*/
	$wp_customize->add_section(
        'top_header',
        array(
        	'priority'      => 5,
            'title' 		=> __('Top Header','civil-construction'),
			'panel'  		=> 'header_section',
		)
    );	


	$wp_customize->add_setting('civilconstruction_reset_header_settings',array(
	  'sanitize_callback'   => 'sanitize_text_field'
	));
	$wp_customize->add_control(new civilconstruction_Reset_Custom_Control($wp_customize, 'civil_construction_reset_header_settings',array(
	  'type' => 'reset_control',
	   'priority' => 1,
	  'label' => __('Reset Header Settings', 'civil-construction'),
	  'description' => 'civil_construction_header_reset_settings',
	  'section' => 'top_header'
	)));



    $wp_customize->add_setting('civilconstruction_top_header_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new civilconstruction_Tab_Control($wp_customize, 'civilconstruction_top_header_tabs', array(
	   'section' => 'top_header',
	   'priority' => 1,
	   'buttons' => array(
	      array(
     		'name' => esc_html__('General', 'civil-construction'),
 			'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
				'hide_show_sticky',
            	'topheader',
            	'topheader_phn',
            	'topheader_phnicon',
            	'topheader_email',
            	'topheader_mailicon'

            ),
            'active' => true,
         ),
	      array(
            'name' => esc_html__('Style', 'civil-construction'),
            'icon' => 'dashicons dashicons-art',
            'fields' => array(
				'topheader_bgcolor',
				'topheader_titlecolor',
				'topheader_phniconcolor',
				'topheader_phncolor',
				'topheader_mailiconcolor',
				'topheader_mailcolor',
				'topheader_bordercolor'

            ),
         )
	    
    	),
	)));


	// sticky header
	$wp_customize->add_setting( 'hide_show_sticky',array(
        'default' => true,
        'sanitize_callback' => 'civilconstruction_switch_sanitization'
   	) );
   	$wp_customize->add_control( new civilconstruction_Toggle_Switch_Custom_Control( $wp_customize, 'hide_show_sticky',array(
        'label' => __( 'Show Sticky Header','civil-construction' ),
        'section' => 'top_header'
   	)));
	
	
	// topheader txt
	$topheadertxt = esc_html__('Our clients are always comletely satisfied with our services', 'civil-construction' );
	$wp_customize->add_setting(
    	'topheader',
    	array(
			'default' => $topheadertxt,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'topheader',
		array(
		    'label'   		=> __('Title','civil-construction'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);		

	
	// topheader Phone Number
	$topheaderphn = esc_html__('+386 40 111 5555', 'civil-construction' );
	$wp_customize->add_setting(
    	'topheader_phn',
    	array(
			'default' => $topheaderphn,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'topheader_phn',
		array(
		    'label'   		=> __('Phone Number','civil-construction'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);		


	// topheader phone number icon
	$topheaderphnicon = esc_html__('fa fa-phone', 'civil-construction' );
	$wp_customize->add_setting(
    	'topheader_phnicon',
    	array(
			'default' => $topheaderphnicon,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'topheader_phnicon',
		array(
		    'label'   		=> __('Phone Number Icon','civil-construction'),
		    'section'		=> 'top_header',
			'type' 			=> 'icon',
			'transport'         => $selective_refresh,
		)  
	);		


	// topheader Email
	$topheaderphn = esc_html__('info@yourdomain.com', 'civil-construction' );
	$wp_customize->add_setting(
    	'topheader_email',
    	array(
			'default' => $topheaderphn,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'topheader_email',
		array(
		    'label'   		=> __('Email','civil-construction'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);		


	// topheader mail icon
	$topheadermailicon = esc_html__('fa fa-envelope-o', 'civil-construction' );
	$wp_customize->add_setting(
    	'topheader_mailicon',
    	array(
			'default' => $topheadermailicon,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'topheader_mailicon',
		array(
		    'label'   		=> __('Mail Icon','civil-construction'),
		    'section'		=> 'top_header',
			'type' 			=> 'icon',
			'transport'         => $selective_refresh,
		)  
	);		



	//style
	
	// topheader bg color
	$topheaderbgcolor = esc_html__('#00165a', 'civil-construction' );
	$wp_customize->add_setting(
    	'topheader_bgcolor',
    	array(
			'default' => $topheaderbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'topheader_bgcolor',
		array(
		    'label'   		=> __('BG Color','civil-construction'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	// topheader title color
	$topheadertitlecolor = esc_html__('#fff', 'civil-construction' );
	$wp_customize->add_setting(
    	'topheader_titlecolor',
    	array(
			'default' => $topheadertitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'topheader_titlecolor',
		array(
		    'label'   		=> __('Title Color','civil-construction'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	// topheader phone number icon color
	$topheaderphniconcolor = esc_html__('#ffffff', 'civil-construction' );
	$wp_customize->add_setting(
    	'topheader_phniconcolor',
    	array(
			'default' => $topheaderphniconcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'topheader_phniconcolor',
		array(
		    'label'   		=> __('Phone Number Icon Color','civil-construction'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// topheader phone number  color
	$topheaderphncolor = esc_html__('#ffffff', 'civil-construction' );
	$wp_customize->add_setting(
    	'topheader_phncolor',
    	array(
			'default' => $topheaderphncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'topheader_phncolor',
		array(
		    'label'   		=> __('Phone Number Color','civil-construction'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	// topheader mail icon color
	$topheadermailiconcolor = esc_html__('#ffffff', 'civil-construction' );
	$wp_customize->add_setting(
    	'topheader_mailiconcolor',
    	array(
			'default' => $topheadermailiconcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'topheader_mailiconcolor',
		array(
		    'label'   		=> __('Mail Icon Color','civil-construction'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// topheader mail  color
	$topheadermailcolor = esc_html__('#ffffff', 'civil-construction' );
	$wp_customize->add_setting(
    	'topheader_mailcolor',
    	array(
			'default' => $topheadermailcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 8,
		)
	);	

	$wp_customize->add_control( 
		'topheader_mailcolor',
		array(
		    'label'   		=> __('Mail Color','civil-construction'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	// topheader border color
	$topheaderbordercolor = esc_html__('#ffffff', 'civil-construction' );
	$wp_customize->add_setting(
    	'topheader_bordercolor',
    	array(
			'default' => $topheaderbordercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'topheader_bordercolor',
		array(
		    'label'   		=> __('Border Color','civil-construction'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	



	$wp_customize->register_control_type('civilconstruction_Tab_Control');
	$wp_customize->register_panel_type( 'civilconstruction_WP_Customize_Panel' );
	$wp_customize->register_section_type( 'civilconstruction_WP_Customize_Section' );

	

}
add_action( 'customize_register', 'civilconstruction_header_settings' );



if ( class_exists( 'WP_Customize_Panel' ) ) {
  	class civilconstruction_WP_Customize_Panel extends WP_Customize_Panel {
	   public $panel;
	   public $type = 'civilconstruction_panel';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'type', 'panel', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;
	      return $array;
    	}
  	}
}

if ( class_exists( 'WP_Customize_Section' ) ) {
  	class civilconstruction_WP_Customize_Section extends WP_Customize_Section {
	   public $section;
	   public $type = 'civilconstruction_section';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'panel', 'type', 'description_hidden', 'section', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;

	      if ( $this->panel ) {
	        $array['customizeAction'] = sprintf( 'Customizing &#9656; %s', esc_html( $this->manager->get_panel( $this->panel )->title ) );
	      } else {
	        $array['customizeAction'] = 'Customizing';
	      }
	      return $array;
    	}
  	}
}




