<?php if ( get_header_image() ) : ?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" id="custom-header" rel="home">
		<img src="<?php esc_url(header_image()); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="<?php echo esc_attr(get_bloginfo( 'title' )); ?>">
	</a>	
<?php endif;  ?>
<!-- Header Area -->
    <header class="main-header <?php echo esc_attr(civilconstruction_sticky_menu()); ?>">
		<?php if ( function_exists( 'peccular_companion_activated' ) ) { ?>
			<button class="top-header-toggler" type="button" data-bs-toggle="collapse" data-bs-target=".top-header"><i class="fa fa-ellipsis-v"></i></button>
		<?php } ?>	


			<?php 
				$topheader = get_theme_mod('topheader','Our clients are always comletely satisfied with our services');
				$topheader_phn = get_theme_mod('topheader_phn','+386 40 111 5555');
				$topheader_phnicon = get_theme_mod('topheader_phnicon','fa fa-phone');
				$topheader_email = get_theme_mod('topheader_email','info@yourdomain.com');
				$topheader_mailicon = get_theme_mod('topheader_mailicon','fa fa-envelope-o');

				$topheader_phniconcolor = get_theme_mod('topheader_phniconcolor','#3a6eff');
				$topheader_mailiconcolor = get_theme_mod('topheader_mailiconcolor','#3a6eff');

			?>
		
			<!-- top header -->
			<div class="topheader">
				<div class="container"> 
					<div class="row">
						<div class="col-md-6 col-lg-6 col-sm-6 border-right space">
							<p><?php echo apply_filters('civilconstruction_topheader', $topheader); ?></p>
						</div>
						<div class="col-md-3 col-lg-3 col-sm-6 border-right space">
							<div class="row">
								<div class="col-md-2 col-lg-2 col-sm-2 col-space-icon">
									<i style="color: <?php echo apply_filters('civilconstruction_topheader', $topheader_phniconcolor); ?>" class="<?php echo apply_filters('civilconstruction_topheader', $topheader_phnicon); ?>" aria-hidden="true"></i>
								</div>
								<div class="col-md-10 col-lg-10 col-sm-10 padding-0 col-space-content">
									<p class="civilconstruction-phone-label"><?php echo apply_filters('civilconstruction_topheader', $topheader_phn); ?></p>
								</div>
							</div>
						</div>
						<div class="col-md-3 col-lg-3 col-sm-6 border-right space">
							<div class="row">
								<div class="col-md-2 col-lg-2 col-sm-2 col-space-icon">
									<i style="color: <?php echo apply_filters('civilconstruction_topheader', $topheader_mailiconcolor); ?>" class="<?php echo apply_filters('civilconstruction_topheader', $topheader_mailicon); ?>" aria-hidden="true"></i>
								</div>
								<div class="col-md-10 col-lg-10 col-sm-10 padding-0 col-space-content">
									<p class="civilconstruction-email-label"><?php echo apply_filters('civilconstruction_topheader', $topheader_email); ?></p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

           <!-- Header -->
            <nav class="navbar navbar-expand-lg navbaroffcanvase">
            	<div class="container">
					<div class="logo">
						<?php
						if(has_custom_logo())
							{	
								the_custom_logo();
							}
							else { 
							?>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
								<h4 class="site-title">
									<?php 
										echo esc_html(bloginfo('name'));
									?>
								</h4>
							</a>	
						<?php 						
							}
						?>
						<?php
							$civilconstruction_site_desc = get_bloginfo( 'description');
							if ($civilconstruction_site_desc) : ?>
								<p class="site-description"><?php echo esc_html($civilconstruction_site_desc); ?></p>
						<?php endif; ?>
					</div>
					
	                <div class="navbar-menubar">
	                    <!-- Small Divice Menu-->
	                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target=".navbar-menu"  aria-label="<?php echo esc_attr_e('Toggle navigation','civil-construction'); ?>"> 
	                        <i class="fa fa-bars"></i>
	                    </button>
	                    <div class="collapse navbar-collapse navbar-menu">
		                    <button class="navbar-toggler navbar-toggler-close" type="button" data-bs-toggle="collapse" data-bs-target=".navbar-menu"  aria-label="<?php echo esc_attr_e('Toggle navigation','civil-construction'); ?>"> 
		                        <i class="fa fa-times"></i>
		                    </button> 
							<?php 
								wp_nav_menu( 
									array(  
										'theme_location' => 'primary_menu',
										'container'  => '',
										'container_id'    => '',
										'menu_class' => 'navbar-nav main-nav',
										'fallback_cb' => 'WP_Bootstrap_Navwalker::fallback',
										'walker' => new WP_Bootstrap_Navwalker()
										 ) 
									);
							?>
	                    </div>
	                </div>
            	</div>
            </nav>
    </header>